package gov.va.vamf.scheduling.varutility.datalayer;

import gov.va.vamf.scheduling.varutility.utils.DAOConstants;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.object.StoredProcedure;

import java.sql.Types;
import java.util.Map;

public class InstitutionStoredProcedure extends StoredProcedure {

    public InstitutionStoredProcedure(JdbcTemplate jdbcTemplate, String storedProcedureName,
                                      InstitutionResultSetRowMapper institutionResultSetRowMapper) {

        super(jdbcTemplate, storedProcedureName);

        declareParameter(new SqlReturnResultSet(DAOConstants.RESULT_LIST, institutionResultSetRowMapper));
        declareParameter(new SqlParameter(DAOConstants.STATIONS, Types.VARCHAR));

        compile();
    }

    public Map<String, Object> getStoredProcedureResults(Map<String, Object> inParameters) {
        return execute(inParameters);
    }
}
